const SITE_URL = 'https://esatcantravel.net'; // Production URL (localhost for development)

document.addEventListener('DOMContentLoaded', async () => {
    // Check if user is logged in
    const userData = await chrome.storage.local.get('user');
    
    // Show/hide admin link based on user type
    if (userData.user && ['admin', 'manager', 'superadmin'].includes(userData.user.user_type)) {
        document.getElementById('openAdminLink').style.display = 'flex';
    }
    
    // Setup quick links
    document.getElementById('openSiteLink').addEventListener('click', (e) => {
        e.preventDefault();
        chrome.tabs.create({ url: `${SITE_URL}/index.php` });
    });
    
    document.getElementById('openLiveSupportLink').addEventListener('click', (e) => {
        e.preventDefault();
        chrome.tabs.create({ url: `${SITE_URL}/canli-destek.php` });
    });
    
    document.getElementById('openAdminLink').addEventListener('click', (e) => {
        e.preventDefault();
        chrome.tabs.create({ url: `${SITE_URL}/admin.php` });
    });
});
